#include <bits/stdc++.h>
using namespace std;

struct Trkac{

    double pozicija;
    double brzina;
    int mesto;

};

bool uporedi(Trkac t1, Trkac t2){

    return(t1.pozicija<=t2.pozicija);
}



long long mergeAndCount(std::vector<int>& pocetne_pozicije, int left, int mid, int right) {
    std::vector<int> temp(right - left + 1);
    int i = left;       // Index for the left subarray
    int j = mid + 1;    // Index for the right subarray
    int k = 0;          // Index for the temporary merged array
    long long preticanja = 0;

    while (i <= mid && j <= right) {
        if (pocetne_pozicije[i] <= pocetne_pozicije[j]) {
            temp[k++] = pocetne_pozicije[i++];
        } else {
            preticanja += (mid - i + 1);
            temp[k++] = pocetne_pozicije[j++];
        }
    }

    while (i <= mid) {
        temp[k++] = pocetne_pozicije[i++];
    }

    while (j <= right) {
        temp[k++] = pocetne_pozicije[j++];
    }

    // Copy the merged array back to the original array
    for (i = 0; i < k; ++i) {
        pocetne_pozicije[left + i] = temp[i];
    }

    return preticanja;
}

long long mergeSortAndCount(std::vector<int>& pocetne_pozicije, int left, int right) {
    long long preticanja = 0;
    if (left < right) {
        int mid = left + (right - left) / 2;

        preticanja += mergeSortAndCount(pocetne_pozicije, left, mid);
        preticanja += mergeSortAndCount(pocetne_pozicije, mid + 1, right);

        preticanja += mergeAndCount(pocetne_pozicije, left, mid, right);
    }
    return preticanja;
}


long long pokusaj(double vreme, vector<Trkac> trkaci, vector<Trkac> &kopija, int n) {

    for(int i = 0; i<=n-1; i++){

        kopija[i].pozicija = trkaci[i].pozicija + trkaci[i].brzina*vreme;
        kopija[i].mesto = trkaci[i].mesto;
    }

    sort(kopija.begin(), kopija.end(), uporedi);


    /*cout<<"Ovo je vektor kopije"<<endl;

    for(int i = 0; i<=n-1; i++){

        cout<<kopija[i].mesto<<" ";
    }

    cout<<endl;*/

    vector<int>pozicije(n);

    for(int i = 0; i<=n-1; i++){

        pozicije[i] = kopija[i].mesto;
    }

    long long res = mergeSortAndCount(pozicije, 0, n-1);

    return res;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    long long k;
    cin >> n >> k;

    vector<Trkac> trkaci(n);

    for (int i = 0; i < n; i++) {

        cin >> trkaci[i].pozicija>>trkaci[i].brzina;
    }

    sort(trkaci.begin(), trkaci.end(), uporedi);

    vector<Trkac> kopija(n);


    for(int i = 0; i<=n-1; i++){

        trkaci[i].mesto = i;
    }



    double start = 0.0, finish = 1000000000;
    while (finish - start > 0.00001) {

        double mid = start + (finish - start) / 2;

        if (pokusaj(mid, trkaci, kopija, n) >= k) {
            finish = mid;
        } else {
            start = mid;
        }
    }

    cout.precision(10);

    cout << start << endl;

    //cout<<pokusaj(1.33333333, trkaci, kopija, n);


    /*for(int i = 0; i<=n-1; i++){

        cout<<trkaci[i].pozicija<<" ";
    }*/

}